/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminAddRemoveWflGroupsPanel;
import filenet.vw.toolkit.admin.result.VWAdminDataObjForWFGroups;
import filenet.vw.toolkit.admin.result.VWAdminFilteredAddRemoveWflGroupsPanel;
import filenet.vw.toolkit.admin.result.VWAdminItemInList;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminWflGroupDataObj;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.IVWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class VWAdminManageWflGroupsDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener,
ItemListener {
    private JComboBox m_wflGroupsCMB = null;
    private JLabel m_groupName = null;
    private IVWUsersAndGroupsPanel m_addRemovePanel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private boolean m_bCanceled = true;
    private boolean m_bLocked = false;
    private VWSession m_session = null;
    private Vector m_vSelectedWork = null;
    private Vector m_vGroups = null;

    public VWAdminManageWflGroupsDialog(Vector selectedWork, VWAdminResultPane resultsPane) {
        super(resultsPane.getParentFrame());
        this.m_session = resultsPane.getSession();
        this.m_vSelectedWork = selectedWork;
        this.m_vGroups = new Vector();
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        Dimension dim = VWStringUtils.stringToDimension("665,385");
        if (dim == null) {
            dim = new Dimension(600, 350);
        }
        this.setSize(dim);
        this.setTitle(VWResource.s_manageWflGroupsTitle);
        this.setVisible(false);
        this.setLocationRelativeTo(resultsPane.getParentFrame());
        this.getContentPane().add((Component)this.createHeaderPanel(), "First");
        try {
            this.m_addRemovePanel = this.m_session.getSecurityDatabaseType() == 1 ? new VWAdminFilteredAddRemoveWflGroupsPanel(this, this.m_session) : new VWAdminAddRemoveWflGroupsPanel(this.m_session);
            if (this.m_addRemovePanel instanceof VWAdminFilteredAddRemoveWflGroupsPanel) {
                JLabel availableLabel = ((VWAdminFilteredAddRemoveWflGroupsPanel)this.m_addRemovePanel).getAvailableLabel();
                JLabel selectedLabel = ((VWAdminFilteredAddRemoveWflGroupsPanel)this.m_addRemovePanel).getSelectedLabel();
                JList availableJList = ((VWAdminFilteredAddRemoveWflGroupsPanel)this.m_addRemovePanel).getAvailableJList();
                JList selectedJList = ((VWAdminFilteredAddRemoveWflGroupsPanel)this.m_addRemovePanel).getSelectedJList();
                VWAccessibilityHelper.setLabelFor(availableLabel, availableJList);
                VWAccessibilityHelper.setLabelFor(selectedLabel, selectedJList);
            } else if (this.m_addRemovePanel instanceof VWAdminAddRemoveWflGroupsPanel) {
                JLabel availableLabel = ((VWAdminAddRemoveWflGroupsPanel)this.m_addRemovePanel).getAvailableLabel();
                JLabel selectedLabel = ((VWAdminAddRemoveWflGroupsPanel)this.m_addRemovePanel).getSelectedLabel();
                JList availableJList = ((VWAdminAddRemoveWflGroupsPanel)this.m_addRemovePanel).getAvailableJList();
                JList selectedJList = ((VWAdminAddRemoveWflGroupsPanel)this.m_addRemovePanel).getSelectedJList();
                VWAccessibilityHelper.setLabelFor(availableLabel, availableJList);
                VWAccessibilityHelper.setLabelFor(selectedLabel, selectedJList);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.getContentPane().add((Component)((JPanel)((Object)this.m_addRemovePanel)), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.addWindowListener(new VWWindowAdapter(this));
        this.initializeWflGroupsComboBox();
        this.initializeLists();
    }

    public void removeReferences() {
        super.removeReferences();
        if (this.m_vGroups != null) {
            this.m_vGroups.removeAllElements();
        }
        if (this.m_vSelectedWork != null) {
            this.m_vSelectedWork.removeAllElements();
        }
        if (this.m_addRemovePanel != null) {
            this.m_addRemovePanel.removeReferences();
            this.m_addRemovePanel = null;
        }
        if (this.m_wflGroupsCMB != null) {
            DefaultComboBoxModel dataModel = (DefaultComboBoxModel)this.m_wflGroupsCMB.getModel();
            if (dataModel != null && dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            this.m_wflGroupsCMB = null;
        }
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bCanceled = true;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_okButton) {
            this.m_bCanceled = false;
            int index = this.m_wflGroupsCMB.getSelectedIndex();
            this.updateDataObjects(index);
            this.setVisible(false);
        } else if (object == this.m_cancelButton) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah034.htm");
        }
    }

    public void itemStateChanged(ItemEvent e) {
        int state = e.getStateChange();
        if (state == 2) {
            VWAdminWflGroupDataObj obj = (VWAdminWflGroupDataObj)e.getItem();
            int index = this.findIndex(this.m_wflGroupsCMB, obj.getName());
            this.updateDataObjects(index);
        } else if (state == 1) {
            this.initializeLists();
        }
    }

    protected boolean getStatus() {
        return this.m_bCanceled;
    }

    protected Vector getWflGroupsDataObjects() {
        return this.m_vGroups;
    }

    private JPanel createHeaderPanel() {
        try {
            JPanel headerPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.insets = new Insets(6, 6, 6, 6);
            gbCons.gridx = 0;
            gbCons.gridwidth = 1;
            gbCons.weightx = 0.0;
            this.m_groupName = new JLabel();
            this.m_groupName.setText(VWResource.s_workflowGroups);
            VWAccessibilityHelper.setAccessibility(this.m_groupName, this, VWResource.s_workflowGroups, VWResource.s_workflowGroups);
            headerPanel.add((Component)this.m_groupName, gbCons);
            gbCons.gridwidth = -1;
            gbCons.gridx = -1;
            gbCons.weightx = 1.0;
            this.m_wflGroupsCMB = new JComboBox();
            this.m_wflGroupsCMB.addActionListener(this);
            this.m_wflGroupsCMB.addItemListener(this);
            this.m_wflGroupsCMB.setRenderer(new VWLabelListCellRenderer());
            VWAccessibilityHelper.setAccessibility(this.m_wflGroupsCMB, this, VWResource.s_workflowGroups, VWResource.s_workflowGroups);
            VWAccessibilityHelper.setLabelFor(this.m_groupName, this.m_wflGroupsCMB);
            headerPanel.add((Component)this.m_wflGroupsCMB, gbCons);
            return headerPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_okButton = new JButton(VWResource.s_OK);
            this.m_okButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void initializeComboBox(JComboBox comboBox, Object[] items) {
        try {
            DefaultComboBoxModel<Object> dataModel = new DefaultComboBoxModel<Object>();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    dataModel.addElement(items[i]);
                }
            }
            comboBox.setModel(dataModel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initializeLists() {
        try {
            if (this.m_bLocked) {
                return;
            }
            if (this.m_addRemovePanel instanceof VWAdminFilteredAddRemoveWflGroupsPanel) {
                ((VWAdminFilteredAddRemoveWflGroupsPanel)this.m_addRemovePanel).initializeLists(this.getSelectedItems());
            } else if (this.m_addRemovePanel instanceof VWAdminAddRemoveWflGroupsPanel) {
                ((VWAdminAddRemoveWflGroupsPanel)this.m_addRemovePanel).initializeLists(this.getSelectedItems());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWAdminItemInList[] getSelectedItems() {
        VWAdminWflGroupDataObj obj = (VWAdminWflGroupDataObj)this.m_wflGroupsCMB.getSelectedItem();
        if (obj != null) {
            return obj.getSelectedObjects();
        }
        return null;
    }

    private void updateDataObjects(int index) {
        Object[] selectedItems = null;
        if (this.m_bLocked) {
            return;
        }
        if (index < 0) {
            return;
        }
        VWAdminWflGroupDataObj obj = (VWAdminWflGroupDataObj)this.m_wflGroupsCMB.getItemAt(index);
        if (obj == null) {
            return;
        }
        if (this.m_addRemovePanel != null && this.m_addRemovePanel instanceof VWAdminFilteredAddRemoveWflGroupsPanel) {
            selectedItems = ((VWAdminFilteredAddRemoveWflGroupsPanel)this.m_addRemovePanel).getSelectedItems();
        } else if (this.m_addRemovePanel != null && this.m_addRemovePanel instanceof VWAdminAddRemoveWflGroupsPanel) {
            selectedItems = ((VWAdminAddRemoveWflGroupsPanel)this.m_addRemovePanel).getSelectedItems();
        }
        obj.setParticipants(selectedItems);
    }

    private Object[] initParticipantList(String wflGroupName, boolean checkForGray) {
        Object[] selectedNames = null;
        Vector<VWAdminItemInList> v_selectedItems = new Vector<VWAdminItemInList>();
        for (int i = 0; i < this.m_vSelectedWork.size(); ++i) {
            VWParticipant[] participants;
            VWAdminDataObjForWFGroups obj = (VWAdminDataObjForWFGroups)this.m_vSelectedWork.elementAt(i);
            VWAdminWflGroupDataObj wflGroupData = this.isWflGroupInObject(obj, wflGroupName);
            if (wflGroupData == null || (participants = wflGroupData.getParticipants()) == null) continue;
            VWParticipantItem[] participantItems = null;
            try {
                participantItems = VWDefaultSessionProxy.getFullParticipantItems(participants, false);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                participantItems = VWDefaultSessionProxy.getParticipantItemsUsingParticipants(participants, false);
            }
            if (participantItems == null) continue;
            try {
                for (int j = 0; j < participantItems.length; ++j) {
                    String participantName = participantItems[j].getShortName();
                    if (participantName == null || participantName.length() == 0 || this.isInVector(participantName, v_selectedItems)) continue;
                    boolean b_grayedOut = false;
                    if (checkForGray && !this.isUserInAllWork(participantName, wflGroupName)) {
                        b_grayedOut = true;
                    }
                    VWAdminItemInList item = new VWAdminItemInList(participantItems[j].getVWParticipant(), b_grayedOut);
                    v_selectedItems.addElement(item);
                }
                continue;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        if (v_selectedItems.size() > 0) {
            selectedNames = new Object[v_selectedItems.size()];
            v_selectedItems.copyInto(selectedNames);
        }
        return selectedNames;
    }

    private VWAdminWflGroupDataObj isWflGroupInObject(VWAdminDataObjForWFGroups obj, String wflGroupName) {
        Vector v_wflGroups = obj.getWflGroups();
        for (int j = 0; j < v_wflGroups.size(); ++j) {
            VWAdminWflGroupDataObj wflGroupInfo = (VWAdminWflGroupDataObj)v_wflGroups.elementAt(j);
            if (VWStringUtils.compareIgnoreCase(wflGroupName, wflGroupInfo.getName()) != 0) continue;
            return wflGroupInfo;
        }
        return null;
    }

    private boolean isUserInAllWork(String participantName, String wflGroupName) {
        for (int i = 0; i < this.m_vSelectedWork.size(); ++i) {
            VWAdminDataObjForWFGroups obj = (VWAdminDataObjForWFGroups)this.m_vSelectedWork.elementAt(i);
            Vector v_wflGroups = obj.getWflGroups();
            for (int j = 0; j < v_wflGroups.size(); ++j) {
                VWAdminWflGroupDataObj wflGroupInfo = (VWAdminWflGroupDataObj)v_wflGroups.elementAt(j);
                if (VWStringUtils.compareIgnoreCase(wflGroupName, wflGroupInfo.getName()) != 0 || this.isUserInGroup(participantName, wflGroupInfo.getParticipants())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isUserInGroup(String participantName, VWParticipant[] participants) {
        if (participants == null || participants.length == 0) {
            return false;
        }
        for (int i = 0; i < participants.length; ++i) {
            if (VWStringUtils.compareIgnoreCase(participantName, participants[i].getParticipantName()) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean isInVector(String shortName, Vector aVector) {
        try {
            if (aVector.size() == 0) {
                return false;
            }
            for (int i = 0; i < aVector.size(); ++i) {
                VWAdminItemInList item = (VWAdminItemInList)aVector.elementAt(i);
                if (VWStringUtils.compare(shortName, item.getShortName()) != 0) continue;
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private void initializeWflGroupsComboBox() {
        Object[] items = null;
        Object[] selectedNames = null;
        this.m_bLocked = true;
        for (int i = 0; i < this.m_vSelectedWork.size(); ++i) {
            VWAdminDataObjForWFGroups obj = (VWAdminDataObjForWFGroups)this.m_vSelectedWork.elementAt(i);
            Vector v_wflGroups = obj.getWflGroups();
            for (int j = 0; j < v_wflGroups.size(); ++j) {
                VWAdminWflGroupDataObj wflGroupInfo = (VWAdminWflGroupDataObj)v_wflGroups.elementAt(j);
                String wflGroupName = wflGroupInfo.getName();
                if (this.isInComboBox(wflGroupName)) continue;
                VWAdminWflGroupDataObj wflGroupObj = new VWAdminWflGroupDataObj();
                selectedNames = this.initParticipantList(wflGroupName, true);
                wflGroupObj.setName(wflGroupName);
                wflGroupObj.setParticipants(selectedNames);
                this.m_vGroups.addElement(wflGroupObj);
            }
        }
        if (this.m_vGroups.size() > 0) {
            items = new Object[this.m_vGroups.size()];
            this.m_vGroups.copyInto(items);
        }
        this.initializeComboBox(this.m_wflGroupsCMB, items);
        this.m_wflGroupsCMB.setSelectedIndex(-1);
        if (this.m_wflGroupsCMB.getItemCount() > 0) {
            this.m_wflGroupsCMB.setSelectedIndex(0);
        }
        this.m_bLocked = false;
    }

    private boolean isInComboBox(String name) {
        for (int i = 0; i < this.m_vGroups.size(); ++i) {
            VWAdminWflGroupDataObj obj = (VWAdminWflGroupDataObj)this.m_vGroups.elementAt(i);
            if (VWStringUtils.compareIgnoreCase(obj.getName(), name) != 0) continue;
            return true;
        }
        return false;
    }

    private int findIndex(JComboBox comboBox, String find) {
        try {
            DefaultComboBoxModel dataModel = (DefaultComboBoxModel)comboBox.getModel();
            int size = dataModel.getSize();
            if (find != null) {
                for (int i = 0; i < size; ++i) {
                    VWAdminWflGroupDataObj obj = (VWAdminWflGroupDataObj)dataModel.getElementAt(i);
                    String s = obj.getName();
                    if (VWStringUtils.compare(s, find) != 0) continue;
                    return i;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }
}

